# Copyright 2022 99cloud
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# flake8: noqa
# fmt: off

from . import base

list_rules = (
    base.Rule(
        name="context_is_admin",
        check_str=("role:admin"),
        description="No description",
    ),
    base.Rule(
        name="admin_or_owner",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="No description",
    ),
    base.Rule(
        name="admin_api",
        check_str=("rule:context_is_admin"),
        description="No description",
    ),
    base.Rule(
        name="admin_or_user",
        check_str=("is_admin:True or user_id:%(user_id)s"),
        description="No description",
    ),
    base.Rule(
        name="cluster_user",
        check_str=("user_id:%(trustee_user_id)s"),
        description="No description",
    ),
    base.Rule(
        name="deny_cluster_user",
        check_str=("not domain_id:%(trustee_domain_id)s"),
        description="No description",
    ),
    base.APIRule(
        name="bay:create",
        check_str=("rule:deny_cluster_user"),
        description="Create a new bay.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/bays"}],
    ),
    base.APIRule(
        name="bay:delete",
        check_str=("rule:deny_cluster_user"),
        description="Delete a bay.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/bays/{bay_ident}"}],
    ),
    base.APIRule(
        name="bay:detail",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of bays with detail.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/bays"}],
    ),
    base.APIRule(
        name="bay:get",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve information about the given bay.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/bays/{bay_ident}"}],
    ),
    base.APIRule(
        name="bay:get_all",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of bays.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/bays/"}],
    ),
    base.APIRule(
        name="bay:update",
        check_str=("rule:deny_cluster_user"),
        description="Update an existing bay.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/bays/{bay_ident}"}],
    ),
    base.APIRule(
        name="baymodel:create",
        check_str=("rule:deny_cluster_user"),
        description="Create a new baymodel.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/baymodels"}],
    ),
    base.APIRule(
        name="baymodel:delete",
        check_str=("rule:deny_cluster_user"),
        description="Delete a baymodel.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/baymodels/{baymodel_ident}"}],
    ),
    base.APIRule(
        name="baymodel:detail",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of baymodel with detail.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/baymodels"}],
    ),
    base.APIRule(
        name="baymodel:get",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve information about the given baymodel.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/baymodels/{baymodel_ident}"}],
    ),
    base.APIRule(
        name="baymodel:get_all",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of baymodel.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/baymodels"}],
    ),
    base.APIRule(
        name="baymodel:update",
        check_str=("rule:deny_cluster_user"),
        description="Update an existing baymodel.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/baymodels/{baymodel_ident}"}],
    ),
    base.APIRule(
        name="baymodel:publish",
        check_str=("rule:admin_api"),
        description="Publish an existing baymodel.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/baymodels"}, {"method": "PATCH", "path": "/v1/baymodels"}],
    ),
    base.APIRule(
        name="certificate:create",
        check_str=("rule:admin_or_user or rule:cluster_user"),
        description="Sign a new certificate by the CA.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/certificates"}],
    ),
    base.APIRule(
        name="certificate:get",
        check_str=("rule:admin_or_user or rule:cluster_user"),
        description="Retrieve CA information about the given bay/cluster.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/certificates/{bay_uuid/cluster_uuid}"}],
    ),
    base.APIRule(
        name="certificate:rotate_ca",
        check_str=("rule:admin_or_owner"),
        description="Rotate the CA certificate on the given bay/cluster.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/certificates/{bay_uuid/cluster_uuid}"}],
    ),
    base.APIRule(
        name="cluster:create",
        check_str=("rule:deny_cluster_user"),
        description="Create a new cluster.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/clusters"}],
    ),
    base.APIRule(
        name="cluster:delete",
        check_str=("rule:deny_cluster_user"),
        description="Delete a cluster.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/clusters/{cluster_ident}"}],
    ),
    base.APIRule(
        name="cluster:delete_all_projects",
        check_str=("rule:admin_api"),
        description="Delete a cluster from any project.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/clusters/{cluster_ident}"}],
    ),
    base.APIRule(
        name="cluster:detail",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of clusters with detail.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters"}],
    ),
    base.APIRule(
        name="cluster:detail_all_projects",
        check_str=("rule:admin_api"),
        description="Retrieve a list of clusters with detail across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters"}],
    ),
    base.APIRule(
        name="cluster:get",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve information about the given cluster.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters/{cluster_ident}"}],
    ),
    base.APIRule(
        name="cluster:get_one_all_projects",
        check_str=("rule:admin_api"),
        description="Retrieve information about the given cluster across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters/{cluster_ident}"}],
    ),
    base.APIRule(
        name="cluster:get_all",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of clusters.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters/"}],
    ),
    base.APIRule(
        name="cluster:get_all_all_projects",
        check_str=("rule:admin_api"),
        description="Retrieve a list of all clusters across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters/"}],
    ),
    base.APIRule(
        name="cluster:update",
        check_str=("rule:deny_cluster_user"),
        description="Update an existing cluster.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/clusters/{cluster_ident}"}],
    ),
    base.APIRule(
        name="cluster:update_health_status",
        check_str=("rule:admin_or_user or rule:cluster_user"),
        description="Update the health status of an existing cluster.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/clusters/{cluster_ident}"}],
    ),
    base.APIRule(
        name="cluster:update_all_projects",
        check_str=("rule:admin_api"),
        description="Update an existing cluster.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/clusters/{cluster_ident}"}],
    ),
    base.APIRule(
        name="cluster:resize",
        check_str=("rule:deny_cluster_user"),
        description="Resize an existing cluster.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/clusters/{cluster_ident}/actions/resize"}],
    ),
    base.APIRule(
        name="cluster:upgrade",
        check_str=("rule:deny_cluster_user"),
        description="Upgrade an existing cluster.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/clusters/{cluster_ident}/actions/upgrade"}],
    ),
    base.APIRule(
        name="cluster:upgrade_all_projects",
        check_str=("rule:admin_api"),
        description="Upgrade an existing cluster across all projects.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/clusters/{cluster_ident}/actions/upgrade"}],
    ),
    base.APIRule(
        name="clustertemplate:create",
        check_str=("rule:deny_cluster_user"),
        description="Create a new cluster template.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/clustertemplates"}],
    ),
    base.APIRule(
        name="clustertemplate:delete",
        check_str=("rule:admin_or_owner"),
        description="Delete a cluster template.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/clustertemplate/{clustertemplate_ident}"}],
    ),
    base.APIRule(
        name="clustertemplate:delete_all_projects",
        check_str=("rule:admin_api"),
        description="Delete a cluster template from any project.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/clustertemplate/{clustertemplate_ident}"}],
    ),
    base.APIRule(
        name="clustertemplate:detail_all_projects",
        check_str=("rule:admin_api"),
        description="Retrieve a list of cluster templates with detail across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clustertemplates"}],
    ),
    base.APIRule(
        name="clustertemplate:detail",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of cluster templates with detail.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clustertemplates"}],
    ),
    base.APIRule(
        name="clustertemplate:get",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve information about the given cluster template.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clustertemplate/{clustertemplate_ident}"}],
    ),
    base.APIRule(
        name="clustertemplate:get_one_all_projects",
        check_str=("rule:admin_api"),
        description="Retrieve information about the given cluster template across project.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clustertemplate/{clustertemplate_ident}"}],
    ),
    base.APIRule(
        name="clustertemplate:get_all",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of cluster templates.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clustertemplates"}],
    ),
    base.APIRule(
        name="clustertemplate:get_all_all_projects",
        check_str=("rule:admin_api"),
        description="Retrieve a list of cluster templates across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clustertemplates"}],
    ),
    base.APIRule(
        name="clustertemplate:update",
        check_str=("rule:admin_or_owner"),
        description="Update an existing cluster template.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/clustertemplate/{clustertemplate_ident}"}],
    ),
    base.APIRule(
        name="clustertemplate:update_all_projects",
        check_str=("rule:admin_api"),
        description="Update an existing cluster template.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/clustertemplate/{clustertemplate_ident}"}],
    ),
    base.APIRule(
        name="clustertemplate:publish",
        check_str=("rule:admin_api"),
        description="Publish an existing cluster template.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/clustertemplates"}, {"method": "PATCH", "path": "/v1/clustertemplates"}],
    ),
    base.APIRule(
        name="federation:create",
        check_str=("rule:deny_cluster_user"),
        description="Create a new federation.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/federations"}],
    ),
    base.APIRule(
        name="federation:delete",
        check_str=("rule:deny_cluster_user"),
        description="Delete a federation.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/federations/{federation_ident}"}],
    ),
    base.APIRule(
        name="federation:detail",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of federations with detail.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/federations"}],
    ),
    base.APIRule(
        name="federation:get",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve information about the given federation.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/federations/{federation_ident}"}],
    ),
    base.APIRule(
        name="federation:get_all",
        check_str=("rule:deny_cluster_user"),
        description="Retrieve a list of federations.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/federations/"}],
    ),
    base.APIRule(
        name="federation:update",
        check_str=("rule:deny_cluster_user"),
        description="Update an existing federation.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/federations/{federation_ident}"}],
    ),
    base.APIRule(
        name="magnum-service:get_all",
        check_str=("rule:admin_api"),
        description="Retrieve a list of magnum-services.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/mservices"}],
    ),
    base.APIRule(
        name="quota:create",
        check_str=("rule:admin_api"),
        description="Create quota.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/quotas"}],
    ),
    base.APIRule(
        name="quota:delete",
        check_str=("rule:admin_api"),
        description="Delete quota for a given project_id and resource.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/quotas/{project_id}/{resource}"}],
    ),
    base.APIRule(
        name="quota:get",
        check_str=("rule:admin_or_owner"),
        description="Retrieve Quota information for the given project_id.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/quotas/{project_id}/{resource}"}],
    ),
    base.APIRule(
        name="quota:get_all",
        check_str=("rule:admin_api"),
        description="Retrieve a list of quotas.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/quotas"}],
    ),
    base.APIRule(
        name="quota:update",
        check_str=("rule:admin_api"),
        description="Update quota for a given project_id.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/quotas/{project_id}/{resource}"}],
    ),
    base.APIRule(
        name="stats:get_all",
        check_str=("rule:admin_or_owner"),
        description="Retrieve magnum stats.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/stats"}],
    ),
    base.APIRule(
        name="nodegroup:get",
        check_str=("rule:admin_or_owner"),
        description="Retrieve information about the given nodegroup.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters/{cluster_id}/nodegroup/{nodegroup}"}],
    ),
    base.APIRule(
        name="nodegroup:get_all",
        check_str=("rule:admin_or_owner"),
        description="Retrieve a list of nodegroups that belong to a cluster.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters/{cluster_id}/nodegroups/"}],
    ),
    base.APIRule(
        name="nodegroup:get_all_all_projects",
        check_str=("rule:admin_api"),
        description="Retrieve a list of nodegroups across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters/{cluster_id}/nodegroups/"}],
    ),
    base.APIRule(
        name="nodegroup:get_one_all_projects",
        check_str=("rule:admin_api"),
        description="Retrieve infornation for a given nodegroup.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/clusters/{cluster_id}/nodegroups/{nodegroup}"}],
    ),
    base.APIRule(
        name="nodegroup:create",
        check_str=("rule:admin_or_owner"),
        description="Create a new nodegroup.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/clusters/{cluster_id}/nodegroups/"}],
    ),
    base.APIRule(
        name="nodegroup:delete",
        check_str=("rule:admin_or_owner"),
        description="Delete a nodegroup.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/clusters/{cluster_id}/nodegroups/{nodegroup}"}],
    ),
    base.APIRule(
        name="nodegroup:update",
        check_str=("rule:admin_or_owner"),
        description="Update an existing nodegroup.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/clusters/{cluster_id}/nodegroups/{nodegroup}"}],
    ),
)

__all__ = ("list_rules",)
