#!/bin/bash

{{/*
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/}}

set -ex
COMMAND="${@:-start}"

function start () {
  confs="--config-file /etc/neutron/neutron.conf"
{{- if ( has "ovn" .Values.network.backend ) }}
  confs+=" --config-file /tmp/pod-shared/ovn.ini"
{{- end }}
{{- if contains "vpnaas" .Values.conf.neutron.DEFAULT.service_plugins }}
  confs+=" --config-file /etc/neutron/neutron_vpnaas.conf"
{{- end }}
{{- if contains "ovn-vpnaas" .Values.conf.neutron.DEFAULT.service_plugins }}
  confs+=" --config-file /etc/neutron/neutron_ovn_vpn_agent.ini"
{{- end }}
{{- if .Values.conf.plugins.taas.taas.enabled }}
  confs+=" --config-file /etc/neutron/taas_plugin.ini"
{{- end }}
{{- if ( has "sriov" .Values.network.backend ) }}
  confs+=" --config-file /etc/neutron/plugins/ml2/sriov_agent.ini"
{{- end }}
{{- if .Values.conf.plugins.l2gateway }}
  confs+=" --config-file /etc/neutron/l2gw_plugin.ini"
{{- end }}
{{- if ( has "tungstenfabric" .Values.network.backend ) }}
  confs+=" --config-file /etc/neutron/plugins/tungstenfabric/tf_plugin.ini"
{{- else }}
  confs+=" --config-file /etc/neutron/plugins/ml2/ml2_conf.ini"
{{- end }}
  confs+=" --config-dir /etc/neutron/neutron.conf.d"

  exec uwsgi --ini /etc/neutron/neutron-api-uwsgi.ini --pyargv " $confs "
}

function stop () {
  kill -TERM 1
}

$COMMAND
