# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

name = {
    'type': 'string',
    'minLength': 1,
    'maxLength': 255,
    'pattern': r'(?i)^[A-Z0-9-._~]+$',
}

uuid = {'type': 'string', 'format': 'uuid'}

uuid_or_name = {'anyOf': [uuid, name]}

detail = {
    'type': ['string', 'boolean'],
    'format': '(?i)^(1|t|true|on|y|yes|0|f|false|off|n|no)$',
}

limit = {'type': 'integer', 'min': 0}

sort_dir = {'type': 'string', 'enum': ['asc', 'desc'], 'default': 'asc'}
